function JBtnMenuItem(owner, parent, name, caption)
{
	this.owner    = owner;
	this.parent   = parent;
	this.name     = name;
	this.caption  = caption;
	this.menuItems = new Array();

	this.addMenuItem = JBtnMenuItem_addMenuItem;
}

function JBtnMenuItem_addMenuItem(owner, parent, name, caption)
{
	var obj = new JBtnMenuItem(owner, parent, name, caption);
	this.menuItems.push(obj);

	return obj;
}

function JButton(owner, parent, name, caption, enabled, rect, action, flags, tab, tabStop, tabIndex, dataset, field)
{
	var self = this,
		_rendered = false,
		_disposed = false;
	
	this.initialize(owner, parent, name, caption, action, rect, flags, field, dataset, tab);

	this.methods   = (cmRender | cmLoad);
	this.flags	   = (flags == null) ? 0 : parseInt(flags);
	this.enabled   = utils.parseBool(enabled);
	this.isDown    = false;
	this.menuItems = [];
	this.mainFormButton = false;
	this.tabStop   = tabStop;
	this.tabIndex  = (tabIndex == null) ? -1 : parseInt(tabIndex);
	this.applyRect = false; 

	this.owner.addImage("button-arrow", "button-arrow.gif", "controls");
	this.owner.addImage("separator", "separator.gif", "controls");
	
	this.render        = render;
	this.load          = load;
	this.click         = click;
	this.addMenuItem   = JBtnMenuItem_addMenuItem;
	this.showMenu      = showMenu;
	this.menuItemClick = menuItemClick;
	this.dispose       = dispose;
	
	function render(fs)
	{
		var style = '';
		if (self.mainFormButton)
			style = 'style="width: ' + self.rect.width + ';" ';
		else
		if (self.applyRect)
		{
			style = 'style="width: ' + self.rect.width + '; '

			if (self.rect.height != null)
				style +=  'height:" ' + self.rect.height + ';';
		}

		fs.append('<button class="button" id="' + self.name + '" objName="' + self.name + '" ' + (self.enabled ? '' : 'disabled="disabled" ') + style + '>' + self.caption);
		if (self.menuItems.length > 0)
		{
			fs.append ('<img id="' + self.name + '_img" style="position:absolute;top:2;" src="' + self.owner.images["button-arrow"].src + '"/>');
		}
		fs.append('</button>');


		renderMenu(fs, self);
	}

	function renderMenu(fs, obj)
	{
		if (obj.menuItems.length > 0)
		{
			var subItems = [];

			fs.append('<div class="btnMenuDiv" id="' + obj.name + '_menu" style="position:absolute;width:auto;top:10;display:none;background-color: white">');
			fs.append('<table class="btnMenu" id="' + obj.name + '_menuTable">');

			obj.menuItems.forEach( function (item, i)
			{
				if (item.caption == '-')
					fs.append('<tr><td><img style="width:100%;height:1" src="'+ self.owner.images["separator"].src + '" /></td></tr>');
				else
				{
					fs.append('<tr><td nowrap="true" style="padding-left: 3; padding-right: 3;"><a class="btnMenuItem" id="' + obj.name + '_item_' + i + '" objName="' + item.name + '" _index="' + i + '" href="javascript:;">' + item.caption + '</a>');
					if (item.menuItems.length > 0)
					{
						fs.append ('<img id="' + item.name + '_img" style="position:relative; top:3; left: -10;" src="' + self.owner.images["button-arrow"].src + '"/>');
						subItems.push(item);
					}
					fs.append('</td></tr>');
				}
			}, self);

			fs.append('</table>');
			fs.append('</div>');

			subItems.forEach( function (itm)
			{
				renderMenu(fs, itm);
			}, self);
		}
	} 

	function load()
	{
		var elem = self.$$();
		var style = elem.style; 

		elem.tabIndex = self.tabIndex;
		elem.onclick = self.click;

		if (self.mainFormButton)
		{
			style.position = 'relative';
			style.marginTop = 4;
			style.marginBottom = 4;
			if (elem.offsetHeight < self.rect.height)
				style.height = self.rect.height;
			style.width = self.rect.width + 8;
		}
		else
		if (self.inplace)
		{
			style.position = 'relative';
		}
		else
		if (self.rect.isRelative())
		{
		}
		else
		{
			style.position = 'absolute';
			style.top = self.rect.top;
			style.left = self.rect.left;
			style.height = self.rect.height;
			style.width = self.rect.width + 4;
//			style.width = self.rect.width - corr;
		}
	  

		if (self.menuItems.length > 0)
		{
			var magic = (browser.isIE) ? 19 : 28;
			var img = self.$(self.name + '_img'); 
			img.style.left = elem.offsetWidth - magic;
			img.style.top = (elem.clientHeight - 16 /*img.clientHeight*/) / 2; 

			setEvents(self);
		}
	}

	function setEvents(obj)
	{
		obj.menuItems.forEach( function (item, i)
		{
			var ielem = self.$(obj.name + '_item_' + i);
			if (ielem == null)
				return;

			if (item.menuItems.length > 0)
			{
				ielem.onclick = self.click;
				setEvents(item);
			}
			else
				ielem.onclick = getClickFunc (obj, i);
		}, self);
	}

	function getClickFunc(item, idx)
	{
		return function() { self.menuItemClick(item, idx); };
	}

	function click(e)
	{
//		var button = self.$(self.name);
		var elem = utils.getEventElement(e);

		if (! self.enabled)
			return;

		var obj = self.owner.getObject(elem.getAttribute('objName'));
		if (obj == null)
			obj = self;

		if (obj.menuItems.length > 0)
		{
			if (e == null)
				e = self.owner.getWindow().event; 

			self.showMenu(e, elem);
			return;
		}

		if (self.action == null)
		{
		}
		else
		if (self.action == raCloseParent)
		{
			self.owner.getObject(self.parent).close(e);
		}
		else
		{
			var ds;
			var parent = self.owner.getObject(self.parent);

			if (utils.inList(self.action, raConfirmPrevious, raClosePrevious))
			{
				var previous = self.owner.getObject(parent.previous);
				if ((previous != null) && (previous.dataset != null) && (previous.dataset.records.length > 0))
				{
					var query  = new Postback(raCloseForm);
	
					//self.owner.activeForm = previous.name;
					self.owner.activeForm = previous;
	
					query.set("obj", previous.name);
					var rec = previous.dataset.getCurrentRecord();
					if ((self.action == raConfirmPrevious) && (rec != null))
					{
						query.set("rec", rec.key);
						query.set("dat", escape(rec.toString()));
					}
	
					self.owner.post(raCloseForm, query);
				}

				parent.close();
			}
			else
			{
				ds = self.dataset;
				if (ds == null)
				{
					while ((parent != null) && (parent.dataset == null))
						parent = self.owner.getObject(parent.parent);

					if (parent != null)
						ds = parent.dataset;
				}

				var query  = new Postback(self.action);
				query.set("obj", self.name);

				if (ds != null)
				{ 
					query.set('ads', ds.name);

					if (ds.recordSelector != null)
						query.set('sel', ds.recordSelector.toString());

					var rec = ds.getCurrentRecord();
					if (rec != null)
					{
						query.set("rec", rec.key);

						if ((!ds.isEmpty() && (rec.getState() != rsUnchanged)))
							query.set("dat", escape(rec.toString()));
					}
				}

				self.owner.post(self.action, query);
			}
		}
	}
	
	function menuItemClick(obj, index)
	{
		var elem = self.$$('_menu');
		elem.style.display = 'none';

		var parent = self.owner.getObject(self.parent);
		var query  = new Postback();

		query.set("obj", self.name);
		query.set("itm", obj.menuItems[index].name);

		var ds = parent.dataset;
		while (ds == null)
		{
			parent = self.owner.getObject(parent.parent);
			ds = parent.dataset;
		}

		var rec = ds.getCurrentRecord();
		if (rec != null)
		{
			query.set("rec", rec.key);
			if (utils.inSet(bfPostData, self.flags) && (!ds.isEmpty() && (rec.getState() != rsUnchanged)))
			{
				query.set("dat", escape(rec.toString()));
			}
		}

		self.owner.post(self.action, query);
	}
	
	function showMenu(event, elem)
	{
		var menuElem;
		menuElem = self.$(elem.getAttribute('objName') + '_menu');
		var doc = self.owner.getDocument();
		if (menuElem.parentNode != doc.body)
			doc.body.appendChild(menuElem);

		var style = menuElem.style;

		if (style.display != 'none')
		{
			utils.cancelEvent(event);
			style.display = 'none';
			return;
		}

		if (self.owner.getObject(elem.getAttribute('objName')).constructor == JBtnMenuItem) 
			self.owner.registerPopup(menuElem.id, false, event);
		else
			self.owner.registerPopup(menuElem.id, true, event);

		style.zIndex  = utils.getParentZIndex(menuElem) + 1000;
		style.display = 'block';

		var btnTop = elem.offsetTop;
		var height = menuElem.clientHeight;
		var width = menuElem.clientWidth;

		var pos = utils.getElementPosition(elem, doc);

		var left = pos.left + elem.offsetWidth + 2;
		if (left + width > doc.body.clientWidth - 15)
		{
			left = doc.body.clientWidth - width - 15;
		}

		var top = pos.top - height;
		if (pos < 10)
		{
			pos = btnTop;
		}

		style.left = left;
		style.top = top;
	}

	function disposeItems(obj)
	{
		if (obj.menuItems.length > 0)
		{
			obj.menuItems.forEach( function (item, i)
			{
				var elem = self.$(obj.name + '_item_' + i);
				if (elem != null)
					elem.onclick = null;

				disposeItems(item);
			}, self);

			self.$(obj.name + '_menu').parentNode.removeChild(self.$(obj.name + '_menu'));
		}
	}

	function dispose()
	{
		if (_disposed)
			return;

		var elem = self.$(self.name);
		if (elem != null) 
			elem.onclick = null;

		disposeItems(self);

		self.base.dispose.call(self);
		_disposed = true;
	}
}

JButton.inheritsFrom(ControlBase);

if (typeof(loadNextScript) != 'undefined')
	loadNextScript();